<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/ForeignTrader.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/ZPNW.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Trader.xsd" xmlns:ns5="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/ForeignTrader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Trader.xsd" xmlns:zpnw="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/ZPNW.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="iso-8859-1" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:text>ZPNW</xsl:text> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_ZPNW" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_ZPNW"> <xsl:for-each select=" ns1:Header|  ns1:* | zpnw:*"> <xsl:apply-templates mode="Ident" select="."/> <xsl:apply-templates mode="rodz_dekl" select="."/> <xsl:apply-templates mode="MiejsceDekl" select="."/> <xsl:apply-templates mode="RodzZab" select="."/> <xsl:apply-templates mode="DaneZglaszajacego" select="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:* | fr:* "/> <xsl:apply-templates mode="AdresZglaszajacego" select="ns1:Declarant | zpnw:Declarant | ns4:* | tr:* | ns5:* | fr:* "/> <xsl:apply-templates mode="DaneNadawcy" select="ns1:Consignor | zpnw:Consignor | ns4:* | tr:* | ns5:* | fr:*"/> <xsl:apply-templates mode="AdresNadawcy" select="ns1:Consignor | zpnw:Consignor | ns4:* | tr:* | ns5:* | fr:*"/> <!-- <xsl:apply-templates mode="DaneReprezentanta" select="ns1:Representative | zpnw:Representative | ns4:* | tr:* | ns5:* | fr:*"/> --> <xsl:apply-templates mode="Wyroby" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA --> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> <!-- SZABLON DOT. POUCZENIA--> <xsl:apply-templates mode="PouczeniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" colspan="2" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator podatkowy NIP/numer PESEL<sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup> </b> </span> </td> <td align="center" colspan="2" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" colspan="1" valign="top"> <td align="left" height="45" valign="top" width="353"/> <td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"> <b>2. Nr dokumentu</b> <br/> <span class="cz16"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"> <b>3. Status</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | zpnw:*"> <table width="955"> <tr> <td align="center" valign="middle"> <div class="cz16"> <b> ZGŁOSZENIE O PLANOWANYM NABYCIU WEWNĄTRZWSPÓLNOTOWYM <br/> WYROBÓW AKCYZOWYCH ZNAJDUJĄCYCH SIĘ POZA PROCEDURĄ ZAWIESZENIA POBORU AKCYZY<br/> NA POTRZEBY WYKONYWANEJ NA TERYTORIUM KRAJU DZIAŁALNOŚCI GOSPODARCZEJ</b> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | zpnw:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Miesiac/Kwartal</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> - <xsl:value-of select="substring(@periodTo,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <br/> <div align="center" class="cz18"/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | zpnw:*"> <table border="1" width="955"> <tr align="left" valign="top"> <td colspan="2"> <b>4. Cel złożenia zgłoszenia</b>(zaznaczyć właściwy kwadrat)</td> </tr> <tr align="left" valign="top"> <td width="472">1. złożenie zgłoszenia <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <br/> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td width="467">2. korekta zgłoszenia <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <br/> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> </tr> </table> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">A. MIEJSCE SKŁADANIA ZGŁOSZENIA</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" width="50"/> <td align="left" colspan="2" valign="top"> <b>5. Urząd skarbowy przyjmujący zgłoszenie</b> <br/>  <span class="cz18"> <xsl:value-of select="//@taxOffice"/> </span> </td> </tr> <tr> <td bgcolor="#CCCCCC"/> <td align="left" valign="top"> <b>6. Data wypełnienia zgłoszenia</b> (rok-miesiąc-dzień) <br/>  <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="left" valign="top"> <b>7. Przewidywane miejsce i data dostawy</b> (rok-miesiąc-dzień) <br/>  <span class="cz18"> <xsl:value-of select="//@expectedDeliveryPlace"/> </span> <span class="cz18"> <xsl:value-of select="//@expectedDateOfArrival"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. Rodzaju zabezpieczenia --> <xsl:template match="*" mode="RodzZab"> <xsl:if test="ns1:* | zpnw:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag2">A.1. RODZAJ ZABEZPIECZENIA</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" width="50"/> <td align="left" valign="top" width="412"> <b>8. Rodzaj zabezpieczenia</b> <br/> <xsl:for-each select="//zpnw:Collateral | //ns1:Collateral">  <xsl:choose> <xsl:when test="@type='JEDN'"> <span class="cz18">jednorazowe</span> </xsl:when> <xsl:when test="@type='GEN'"> <span class="cz18">generalne</span> </xsl:when> <xsl:otherwise> <xsl:text> ... </xsl:text> </xsl:otherwise> </xsl:choose> </xsl:for-each> </td> <td align="left" valign="top" width="471"> <b>9. Numer zabezpieczenia</b> <br/> <xsl:for-each select="//zpnw:Collateral | //ns1:Collateral">  <span class="cz18"> <xsl:value-of select="@number"/> </span> </xsl:for-each> </td> </tr> <tr> <td bgcolor="#CCCCCC"/> <td align="left" valign="top"> <b>10. Data złożenia zabezpieczenia</b> <br/> <xsl:for-each select="//zpnw:Collateral | //ns1:Collateral">  <span class="cz18"> <xsl:value-of select="@date"/> </span> </xsl:for-each> </td> <td align="left" valign="top"> <b>11. Kwota zabezpieczenia akcyzowego <sup>2) 3)</sup> </b> <br/> <xsl:for-each select="//zpnw:Collateral | //ns1:Collateral">  <span class="cz18"> <xsl:value-of select="@amountOfExciseGuarantee"/> </span> </xsl:for-each> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. Dane zglaszajacego --> <xsl:template match="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:*  | fr:*" mode="DaneZglaszajacego"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B.DANE PODMIOTU ZGŁASZAJĄCEGO<sup>1)</sup> </span> <br/> *- dotyczy podmiotów niebędących osobami fizycznymi **- dotyczy podmiotów będących osobami fizycznymi </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1 DANE IDENTYFIKACYJNE </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" valign="top"> <b>12. Rodzaj podmiotu (zaznaczyć właściwy kwadrat): </b> </td> </tr> <tr> <td align="left" valign="top">1. podmiot niebędący osobą fizyczną<br/> <xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData  "> <b> <span class="cz18">X</span> </b> </xsl:for-each> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson"> <b> <span class="cz18">X</span> </b> </xsl:for-each> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>13. Nazwa pełna podmiotu/ dane osobowe (imię, nazwisko, data urodzenia)/ REGON </b> <br/>  <xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData "> <span class="cz18"> <xsl:value-of select=".//@fullName"/> </span> <span class="cz18"> <xsl:value-of select=".//@REGON"/> </span> </xsl:for-each> <xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson"> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select=".//@PESEL"/> </span> </xsl:for-each> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. Adres zglaszajacego --> <xsl:template match="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:*  " mode="AdresZglaszajacego"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA** </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>14. Kraj </b> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>15. Województwo</b> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>16. Powiat</b> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>17. Gmina </b> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>18. Ulica</b> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>19. Nr domu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>20. Nr lokalu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>21. Miejscowość</b> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td width="130"> <b>22. Kod pocztowy</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> <td width="181"> <b>23. Poczta</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> </td> <td colspan="2"> <b>24. Adres e-mail i nr telefonu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@email"/>;</span> <span class="cz18"> <xsl:value-of select=".//@phone"/> </span> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. Dane nadawcy --> <xsl:template match="*" mode="DaneNadawcy"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">C.DANE PODMIOTU NADAWCY<sup>1)</sup> </span> <br/> *- dotyczy podmiotów niebędących osobami fizycznymi **- dotyczy podmiotów będących osobami fizycznymi </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">C.1 DANE IDENTYFIKACYJNE </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" valign="top"> <b>25. Rodzaj podmiotu </b>(zaznaczyć właściwy kwadrat) </td> </tr> <tr> <td align="left" valign="top">1. podmiot niebędący osobą fizyczną<br/> <xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData "> <b> <span class="cz18">X</span> </b> </xsl:for-each> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson  | .//fr:PrivatePerson"> <b> <span class="cz18">X</span> </b> </xsl:for-each> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>26. Nazwa pełna podmiotu/ dane osobowe (imię, nazwisko, data urodzenia)/ IDENTYFIKATOR </b> <br/>  <xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData | ns5:*"> <span class="cz18"> <xsl:value-of select="@fullName"/> </span> / <span class="cz18"> <xsl:value-of select="//@consignorId"/> </span> </xsl:for-each> <xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson | .//fr:PrivatePerson"> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select=".//@PESEL"/> </span> / <span class="cz18"> <xsl:value-of select="//@consignorId"/> </span> </xsl:for-each> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. Adres nadawcy --> <xsl:template match="zpnw:Consignor | ns1:Consignor | tr:* | ns4:* | ns5:* | fr:*" mode="AdresNadawcy"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">C.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA** </span> </td> </tr> <tr align="left" valign="top"> <td> <b>27. Kraj </b> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>28. Ulica</b> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>29. Nr domu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>30. Nr lokalu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>31. Miejscowość</b> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td width="130"> <b>32. Kod pocztowy</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> <td width="181"> <b>33. Poczta</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> </td> <td colspan="2"> <b>34. Adres e-mail i nr telefonu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@email"/>;<xsl:value-of select=".//@phoneConsignor"/> </span> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">ZPNW</span> <sub style="cz9"/> <b style="nag1">(4)/1</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. Dane Reprezentanta --> <xsl:template match="zpnw:Representative | ns1:Representative" mode="DaneReprezentanta"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1"> <b>DANE REPREZENTANTA</b> </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="2" width="46"/> <td align="left" valign="top" width="413"> <b>24.Imię</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> </td> <td align="left" valign="top" width="471"> <b>25. Nazwisko</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> </td> </tr> <tr> <td align="left" colspan="2" valign="top"> <b>26.Numer telefonu i adres e-mail</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@phone"/>;<xsl:value-of select=".//@email"/> </span> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | zpnw:*" mode="Wyroby"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"/> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="6"> <span class="nag1"> <b>D. DANE WYROBÓW AKCYZOWYCH PRZEWIDYWANYCH DO NABYCIA</b> </span> </td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="top"> <td> <span class="cz14"> Lp. </span> </td> <td> <span class="cz14"> Szczegółowy opis wyrobów </span> </td> <td> <span class="cz14">Kod CN </span> </td> <td> <span class="cz14">Ilość/<br/> j. m./<br/>średnia <br/>ważona </span> </td> <td> <span class="cz14">Stawka akcyzy <br/>kwotowa/<br/> procentowa/<br/>minimalna </span> </td> <td> <span class="cz14">Kwota akcyzy w zł <sup>3)</sup> </span> </td> </tr> <xsl:for-each select="//zpnw:Item | //ns1:Item"> <tr> <td> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@id"/> </div> </td> <td> <div align="left" class="cz14" valign="top"> <xsl:value-of select="@goodsName"/> </div> <div align="left" class="cz14" valign="top"> <i> <b> <xsl:value-of select="@groupOfGoodsName"/> </b> </i> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz18"> <xsl:value-of select="@valueOfGoods"/> </div> <div align="right" class="cz18"> <xsl:value-of select="@numberOfGoods"/> <br/> ______ </div> <div align="right" class="cz14"> <xsl:value-of select="@unitOfMeasure"/> <br/> ______ </div> <div align="right" class="cz18"> <xsl:value-of select="@weightedAverageRetailPrice"/> </div> </td> <td> <div align="right" class="cz18"> <xsl:value-of select="@taxRate"/> <br/> ______ </div> <div align="right" class="cz18"> <xsl:value-of select="@taxRatePercentage"/> <br/> ______ </div> <div align="right" class="cz18"> <xsl:value-of select="@taxMin"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> </div> </td> </tr> </xsl:for-each> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | zpnw:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">E. OŚWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span> </b> <br/> Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistoscią.</td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td height="37" width="402"> <b>35. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>36. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>37. Data wypełnienia deklaracji</b> (dzień-miesiąc-rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> <td> <b>38. Podpis (i pieczątka) podatnika lub osoby reprezentującej podatnika </b> </td> </tr> <tr align="left" valign="top"> <td colspan="2" height="70"> <b>39. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:* | zpnw:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="3" height="36">F. ADNOTACJE URZĘDU SKARBOWEGO </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>40.Uwagi urzędu skarbowego <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>41. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>42. Podpis przyjmującego formularz </b> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">ZPNW</span> <sub style="cz9"/> <b style="nag1">(4)/2</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA --> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | zpnw:*"> <table width="955"> <tr> <td> <p> <sup>1)</sup>należy podać imię i nazwisko albo nazwę oraz adres zamieszkania lub siedziby oraz numer identyfikacji podatkowej NIP.</p> <p> <sup>2)</sup>kwota zabezpieczenia akcyzowego obejmuje mogące powstać zobowiązanie podatkowe albo mogące powstać zobowiązanie podatkowe oraz opłatę paliwową, której obowiązek zapłaty może powstać.</p> <p> <sup>3)</sup>Kwotę zabezpieczenia akcyzowego i kwotę akcyzy zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2017 r. poz. 201).</p> </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>